function [output] = R2(T1,C)
%J-coupling is ignored.

%pauli matrices
sx=[0,1;1,0];
sy=[0,-1i;1i,0];
sz=[1,0;0,-1];
id=[1,0;0,1];

%spin operators
I1x=0.5*kron(sx,id);
I1y=0.5*kron(sy,id);
I1z=0.5*kron(sz,id);
I2x=0.5*kron(id,sx);
I2y=0.5*kron(id,sy);
I2z=0.5*kron(id,sz);

%Relaization supermatrix, following the eq.(6) in J.Chem.Phys.129,234513(2008)

%J_mu mu' nu nu'
J11=kron(I1x,transpose(I1x))+kron(I1y,transpose(I1y))+kron(I1z,transpose(I1z))+kron(I2x,transpose(I2x))+kron(I2y,transpose(I2y))+kron(I2z,transpose(I2z));
J12=kron(I1x,transpose(I2x))+kron(I1y,transpose(I2y))+kron(I1z,transpose(I2z))+kron(I2x,transpose(I1x))+kron(I2y,transpose(I1y))+kron(I2z,transpose(I1z));
J1=J11/T1+C*J12/T1;

%(Sum_chi J_chi mu' chi mu)_mu mu'
J21=I1x*I1x+I1y*I1y+I1z*I1z+I2x*I2x+I2y*I2y+I2z*I2z;
J22=I2x*I1x+I1x*I2x+I1y*I2y+I2y*I1y+I2z*I1z+I1z*I2z;
J2=J21/T1+C*J22/T1;

%sigma_nu nu' Sum_mu mu'
J3=kron(J2,eye(4));

%sigma_mu mu' Sum_nu' nu
J4=kron(eye(4),transpose(J2));

output=0.5*(2*J1-J3-J4);

end

