function Surface = Surf_Radius(theta,phi)
% Surf_Radius{i}(:,:,k) returns the surface plotted with the measurement
% opeator labelled by i given a density opeator labelled by k. (See below)

%i=1----(|11><11|)_n; 
%i=2----|00><00|;
%i=3----1/sqrt(2)*(I1z-I2z)_n;
%i=4----sqrt(2)*(I1yI2x-I1xI2y)_n;

%k=1----\rho=zeros(4);\rho_{1,1}=1;
%k=2----\rho=zeros(4);\rho_{2,1}=1;
%k=3----\rho=zeros(4);\rho_{3,1}=1;
%k=4----\rho=zeros(4);\rho_{4,1}=1;
%k=4----\rho=zeros(4);\rho_{1,2}=1;
%k=5----\rho=zeros(4);\rho_{2,2}=1;
%...
%k=15----\rho=zeros(4);\rho_{3,4}=1;
%k=16----\rho=zeros(4);\rho_{4,4}=1;

syms u v
%u=theta; v=phi

[dim,~]=size(theta);

M=cell(4,1);

M{1}=P_11();
M{2}=P_00();
M{3}=P_z();
M{4}=P_ZQ();

Surface=cell(4,1);

for i=1:1:4
    index=0;
    Sub=zeros(dim,dim,16);
    for j=1:4
        for k=1:4
            index=index+1;
            elem=M{i}(j,k);
            f=simplify(elem);
            f = matlabFunction(f,'Var',[u,v]);
            Sub(:,:,index)=feval(f,theta,phi);
        end
    end
    Surface{i}=Sub;
end

end

function A = P_11()
%u=\theta;v=\phi
%A=(|11><11|)_n written in Zeeman basis
syms u v
A=[cos(u/2)^4,exp(-1i*v)*cos(u/2)^2*sin(u)/sqrt(sym(2)),exp(-2*1i*v)*cos(u/2)^2*sin(u/2)^2,0
   exp(1i*v)*cos(u/2)^2*sin(u)/sqrt(sym(2)),sin(u)^2/2, exp(-1i*v)*sin(u/2)^2*sin(u)/sqrt(sym(2)),0
   exp(2*1i*v)*cos(u/2)^2*sin(u/2)^2,exp(1i*v)*sin(u/2)^2*sin(u)/sqrt(sym(2)),sin(u/2)^4,0
   0,0,0,0];
P=[1 0 0 0
   0 1/sqrt(sym(2)) 0 1/sqrt(sym(2))
   0 1/sqrt(sym(2)) 0 -1/sqrt(sym(2))
   0 0 1 0];
A=P*A*P';
end

function A = P_00()
%u=\theta;v=\phi
%A = |00><00| written in Zeeman basis
A=[0,0,0,0
   0,0,0,0
   0,0,0,0
   0,0,0,1];
P=[1 0 0 0
   0 1/sqrt(sym(2)) 0 1/sqrt(sym(2))
   0 1/sqrt(sym(2)) 0 -1/sqrt(sym(2))
   0 0 1 0];
A=P*A*P';
end

function A = P_z()
%u=\theta;v=\phi
%A=1/sqrt(2)*(I1z-I2z)_n written in Zeeman basis
syms u v

A=[0,0,0,-exp(-1i*v)*sin(u)/sqrt(sym(2))
   0,0,0,cos(u)
   0,0,0,exp(1i*v)*sin(u)/sqrt(sym(2))
   -exp(1i*v)*sin(u)/sqrt(sym(2)),cos(u),exp(-1i*v)*sin(u)/sqrt(sym(2)),0];

P=[1 0 0 0
   0 1/sqrt(sym(2)) 0 1/sqrt(sym(2))
   0 1/sqrt(sym(2)) 0 -1/sqrt(sym(2))
   0 0 1 0];

A=1/sqrt(2)*P*A*P';
end

function A = P_ZQ()
%u=\theta;v=\phi
%A=sqrt(2)*(I1yI2x-I1xI2y)_n written in Zeeman basis
syms u v

A=[0,0,0,-1i*exp(-1i*v)*sin(u)/sqrt(sym(2))
   0,0,0,1i*cos(u)
   0,0,0,1i*exp(1i*v)*sin(u)/sqrt(sym(2))
   1i*exp(1i*v)*sin(u)/sqrt(sym(2)),-1i*cos(u),-1i*exp(-1i*v)*sin(u)/sqrt(sym(2)),0];

P=[1 0 0 0
   0 1/sqrt(sym(2)) 0 1/sqrt(sym(2))
   0 1/sqrt(sym(2)) 0 -1/sqrt(sym(2))
   0 0 1 0];

A=1/sqrt(2)*P*A*P';
end



