Steps for reproducing Syed et al 2024:

- Get GISSMO raw data, either:
  - Run `scripts/fit1d_gissmo_download.sh` script to download
  - Extract local copy: `tar -xzf data/fit1d_gissmo.tar.gz`
- Unzip GISSMO data, run: `scripts/fit1d_gissmo_unzip.sh` script
- Make FID conversion and NMR processing scripts, either:
  - Use `bruker` program in all fit1d/*/*/*/1H directories and create nmrproc.com scripts
  - Extract local copy: `tar -xzf data/fit1d_nmrpipe_com.tar.gz`
- Make test.ft1 files, either:
  - Run `scripts/fit1d_nmrpipe_run.sh` script
  - Extract local copy: `tar -xzf data/fit1d_nmrpipe_output.tar.gz`
- Extract FitNMR start parameters: `tar -xzf data/fit1d_fitnmr_start.tar.gz`
- Make FitNMR fit output, either:
  - Run `scripts/fit1d_fitnmr_run.sh` script
  - Extract local copy: `tar -xzf data/fit1d_fitnmr_output.tar.gz`
- Get representative amino acid structures
  - Run `scripts/aa_model_download.sh` script
  - Extract local copy: `tar -xzf data/aa_model.tar.gz`
- Make amino acid images:
  - Run `aa_images/ile.pml` and `aa_images/beta.pml` in PyMOL
  - Extract local copy: `tar -xzf data/aa_images.tar.gz`


The Dunbrak 2010 rotamer library dataset was obtained by following the instructions here:

http://dunbrack.fccc.edu/lab/bbdep2010

Its license is here (based on Creative Commons CC BY 4.0 license):

http://dunbrack.fccc.edu/lab/bbdep2010_lic
